#include "MojeOkno.h"
#include "Varia.h" //JednostkowyWektorNormalny3fv
#include "Modele.h" //Rysuj...
//#include "glext.h"
#include "resource.h"

CMojeOknoGL::CMojeOknoGL()
	:COknoGL()
{
	daneOCT=new Kostka3D();
}

CMojeOknoGL::~CMojeOknoGL()
{
	delete daneOCT;
}

void CMojeOknoGL::RysujAktorow()
{	
	static bool daneWczytane=false;
	if(!daneWczytane) 
	{
		daneWczytane=true;
		daneOCT->WczytajDane("kostka.bin");
	}

	
	daneOCT->RysujPrzekroje();

	//inicjowanie tekstur
//	static bool teksturyZainicjowane=false;
//	if (!teksturyZainicjowane)
//	{
//		PrzygotujTekstury();
//		teksturyZainicjowane=true;
//	}

	/*
	//tworzenie czcionki bitmapowej
	static unsigned int czcionkaBitmapowa=NULL;	
	if (czcionkaBitmapowa==NULL) czcionkaBitmapowa=StworzCzcionke(false,uchwytOkna,"Arial CE",30,true,false,32,255);
	//tworzenie czcionki 3D
	static unsigned int czcionka3D=NULL;
	if (czcionka3D==NULL) czcionka3D=StworzCzcionke(true,uchwytOkna,"Times New Roman CE",30,true,false,48,58);
	*/
	
	const float x0=1.0; 
	const float y0=1.0; 
	const float z0=1.0; 	


	//RysujPodloze(x0,-y0,z0);
	//RysujNiebo(x0,10*y0,z0);
	
	//glColor3f(1,1,0);
	//RysujOsie(x0,y0,z0);

	//RysujTrojkat(x0,y0,z0);

	/*
	//statyczna kostka
	glShadeModel(GL_FLAT);
	glPushMatrix();	
	//glRotatef(30,1,1,1);
	GladkiMaterial(true);
	Modele::RysujSzescian(2*x0,true,indeksTekstury);
	GladkiMaterial(false);
	glPopMatrix();
	*/

	/*
	//statyczny niszczyciel gwiazd
	glPushMatrix();	
	glRotatef(-70,0,1,0);
	glRotatef(-90,1,0,0);	
	Modele::RysujNiszczycielaGwiazd(2*x0,2*y0,2*z0);	
	glPopMatrix();
	*/
	
	//tworzenie list wyswietlania
//	static GLuint listyWyswietlania=NULL;
//	if(!glIsList(listyWyswietlania))
//		listyWyswietlania=TworzListyWyswietlania(x0,y0,z0,false);
	
	/*
	//animacja: niszczyciel gwiazd wylatujacy znad kadru 
	//(zob. stala ANIMACJA w metodzie WndProc)
	glPushMatrix();
	glColor3f(1,1,1);
	glTranslatef(0,1,10-przesuniecie);
	glRotatef(-90,1,0,0);	
	//glEnable(GL_TEXTURE_2D);
	//Modele::RysujNiszczycielaGwiazd(3*x0,3*y0,3*z0);
	glCallList(listyWyswietlania+1);
	glDisable(GL_TEXTURE_2D);
	glPopMatrix();
	*/

	
	/*
	//obracajaca sie kostka
	glPushMatrix();
	glTranslatef(0,-1,0);
	long biezacyCzas=GetTickCount();
	float katPhi=0.1f*biezacyCzas;
	float katTheta=0.01f*biezacyCzas;
	glRotatef(katPhi,0,1,0);
	glRotatef(katTheta,1,0,0);
	//Modele::RysujSzescian(x0,true,indeksTekstury);
	glCallList(listyWyswietlania);
	glPopMatrix();
	*/

	
	/*
	//szescian z usrednianiem normalnych
	glPushMatrix();
	glRotatef(30,1,1,1);
	glColor3f(1,1,1);
	Modele::RysujSzescian_UsrednianieNormalnych(x0);
	glPopMatrix();
	*/

	
	/*
	//szescian z polyskiem
	//glShadeModel(GL_FLAT);
	glShadeModel(GL_SMOOTH);
	glPushMatrix();	
	//glRotatef(30,1,1,1);
	GladkiMaterial(true);
	Modele::RysujSzescian(2*x0,true,indeksTekstury);	
	GladkiMaterial(false);
	glPopMatrix();
	*/

	//mieszanie kolorow - przezroczystosc
	/*
	glBegin(GL_QUADS);	
	glColor4f(1,1,1,1);
	glVertex3f(-x0,-y0,-z0/2);
	glVertex3f(x0,-y0,-z0/2);
	glVertex3f(x0,y0,-z0/2);
	glVertex3f(-x0,y0,-z0/2);
	glNormal3f(0,0,1);
	glEnd();
	glDisable(GL_DEPTH_TEST);
	float alfa=0.5;
	glPushMatrix();		
	for(int i=0;i<2;i++)
	{				
		glColor4f((1.0f-i),1.0f*i,0,alfa);
		glTranslatef((i-0.5f)*x0,0,i*z0/2);		
		glBegin(GL_QUADS);	
		glVertex3f(-x0,-y0,0);
		glVertex3f(x0,-y0,0);
		glVertex3f(x0,y0,0);
		glVertex3f(-x0,y0,0);
		glNormal3f(0,0,1);
		glEnd();
	}	
	glPopMatrix();
	glEnable(GL_DEPTH_TEST);
	*/

	//mieszanie kolorow - polprzezroczystosc
	/*
	GladkiMaterial(false);
	glColor4f(1.0f,1.0f,1.0f,0.5f);	
	Modele::RysujProstopadloscian_SortowanieScian(2*x0,2*y0,2*z0,true,0.5f);
	*/

	/*
	//teksturowanie kostki
	glPushMatrix();	
	glRotatef(30,1,1,1);
	GladkiMaterial(true);
	glColor4f(1,1,1,1);
	glEnable(GL_TEXTURE_2D);
	Modele::RysujSzescian(2*x0,false,false,indeksTekstury);		
	//glScalef(2,2,2);glCallList(listyWyswietlania);		
	//Modele::RysujProstopadloscian_SortowanieScian(2*x0,2*y0,2*z0,false,0.5f,indeksTekstury);
	//Modele::RysujNiszczycielaGwiazd(x0,y0,z0);
	glDisable(GL_TEXTURE_2D);
	GladkiMaterial(false);
	glPopMatrix();
	*/

	/*
	//uzycie czcionki bitmapowej
	glPushMatrix();
	glRotatef(30,1,1,1); //obrot taki, jak przy szescianie
	glColor3f(0.75,1.0,0.75);
	glNormal3f(0,0,1);
	glRasterPos3f(-1.5f,-1.2f,1.1f); Pisz("(0,0,1)",7,czcionkaBitmapowa,32);
	glRasterPos3f(1.1f,-1.2f,1.1f); Pisz("(1,0,1)",7,czcionkaBitmapowa,32);
	glRasterPos3f(-1.5f,1.1f,1.1f); Pisz("(0,1,1)",7,czcionkaBitmapowa,32);
	glRasterPos3f(1.1f,1.1f,1.1f); Pisz("(1,1,1)",7,czcionkaBitmapowa,32);
	glRasterPos3f(-1.5f,-1.2f,-1.1f); Pisz("(0,0,0)",7,czcionkaBitmapowa,32);
	glRasterPos3f(1.1f,-1.2f,-1.1f); Pisz("(1,0,0)",7,czcionkaBitmapowa,32);
	glRasterPos3f(-1.5f,1.1f,-1.1f); Pisz("(0,1,0)",7,czcionkaBitmapowa,32);
	glRasterPos3f(1.1f,1.1f,-1.1f); Pisz("(1,1,0)",7,czcionkaBitmapowa,32);
	glPopMatrix();
	*/

	/*
	//teksturowanie niszczyciela
	glPushMatrix();	
	glColor4f(1,1,1,1);
	glEnable(GL_TEXTURE_2D);
	//Modele::RysujNiszczycielaGwiazd(x0,y0,z0);		
	glCallList(listyWyswietlania+1);
	glDisable(GL_TEXTURE_2D);
	glPopMatrix();
	*/

	/*
	//uzycie czcionki 3D
	glPushMatrix();
	SYSTEMTIME biezacaData; 
	GetLocalTime(&biezacaData); 
	char bufor[256]="";
	char buforTmp[256]="";
	itoa(biezacaData.wHour,bufor,10);
	strcat(bufor,":");
	itoa(biezacaData.wMinute,buforTmp,10);
	if (biezacaData.wMinute<10) strcat(buforTmp,"0");
	strcat(bufor,buforTmp);
	strcat(bufor,":");
	itoa(biezacaData.wSecond,buforTmp,10);
	if (biezacaData.wSecond<10) strcat(bufor,"0");
	strcat(bufor,buforTmp);
	strcat(bufor,"\0");
	glScalef(1.5,1.5,3);
	glTranslatef(-1.5,0,0);	
	glColor3f(biezacaData.wHour/24.0f,biezacaData.wMinute/60.0f,biezacaData.wSecond/60.0f);
	Pisz(bufor,strlen(bufor),czcionka3D,48);
	glPopMatrix();
	*/

	/*		
	//kwadryki - sfera
	glColor3f(1,1,1); 
	glShadeModel(GL_SMOOTH);
	//glShadeModel(GL_FLAT);	
	GladkiMaterial(true);
	RysujSfere(1.5f*x0,true);
	GladkiMaterial(false);	
	*/

	//*
	//kwadryki - latarnia
//	glColor3f(1,1,1); 
//	glShadeModel(GL_SMOOTH);
	//glShadeModel(GL_FLAT);	
	//GladkiMaterial(true);
//	glTranslatef(-0.25f*x0,0.75f*x0,0);
//	Modele::RysujLatarnie(2.5f*x0);
	//GladkiMaterial(false);	
	//*/
}

#pragma region Aktorzy
//Wiekszosc aktorow jest w klasie Modele (Modele.h/Modele.cpp)

void CMojeOknoGL::RysujTrojkat(float x0,float y0,float z0) const
{
	//Rysowanie trojkata 
	glBegin(GL_TRIANGLES); 
	//ustalanie trzech wierzcholkow trojkata (werteksow (x,y,z)) 
	//(0,0,z) jest mniej wiecej w srodku ekranu 
	glColor3f(1.0,0.0,0.5);
	glVertex3f(-x0, -y0, 0); //dolny lewy 
	glColor3f(0.5,0.0,1.0);
	glVertex3f(x0, -y0, 0); //dolny prawy 
	glColor3f(0.0,1.0,0.5);
	glVertex3f(0, y0, 0); //gorny 
	//koniec rysowania figury 
	glEnd();
}
#pragma endregion


//lista wyswietlania
unsigned int CMojeOknoGL::TworzListyWyswietlania(float dx,float dy,float dz,bool koloruj) const
{
	GLuint listyWyswietlania=glGenLists(2);

	glNewList(listyWyswietlania,GL_COMPILE); //EXECUTE - bo mamy dowolne parametry potencjalnie nieznane w momencie kompilacji
	Modele::RysujSzescian(dx,koloruj,true,indeksTekstury);
	glEndList();

	glNewList(listyWyswietlania+1,GL_COMPILE); //EXECUTE - bo mamy dowolne parametry potencjalnie nieznane w momencie kompilacji
	Modele::RysujNiszczycielaGwiazd(3*dx,3*dy,3*dz);
	glEndList();

	return listyWyswietlania;
}

#pragma region Animacja
//timer animacji
#include <mmsystem.h>

LRESULT CMojeOknoGL::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{	
	const bool ANIMACJA=false;
	const int IDT_TIMER_ANIMACJI=1;

	switch (message)
	{
		case WM_KEYDOWN:
		switch(wParam)
		{
			case 'J':
				daneOCT->ZwiekszJasnosc();
				break;
			case 'N':
				daneOCT->ZmniejszJasnosc();
				break;
			case 'K':
				daneOCT->ZwiekszKontrast();
				break;
			case 'M':
				daneOCT->ZmniejszKontrast();
				break;
			case 'H':
				daneOCT->WlaczKolor();
				break;
			case 'B':
				daneOCT->WylaczKolor();
				break;
			case 'G':
				daneOCT->ZwiekszPrzezroczystosc();
				break;
			case 'V':
				daneOCT->ZmniejszPrzezroczystosc();
				break;
		}
	}

	long wynik=COknoGL::WndProc(hWnd,message,wParam,lParam);

	if(!ANIMACJA) 
	{
		przesuniecie=10;
		return wynik;
	}	

	switch (message)
	{
		case WM_CREATE: //pole uchwyt okna nie jest zainicjowane w WM_CREATE -> uzywac hWnd
			if (SetTimer(hWnd,IDT_TIMER_ANIMACJI,50,NULL)==0)
				MessageBox(hWnd,"Nie udao si ustawi timera","",MB_OK | MB_ICONERROR);
			przesuniecie=0;
			poprzedniCzas=GetTickCount();
			PlaySound("M:\\MUZYKA\\Imperial March.wav",NULL,SND_FILENAME | SND_ASYNC);						
			break;
		case WM_TIMER:
			switch(wParam)
			{
				case IDT_TIMER_ANIMACJI:					
					long biezacyCzas=GetTickCount();
					przesuniecie+=0.0005f*(biezacyCzas-poprzedniCzas);
					poprzedniCzas=biezacyCzas;
					RysujScene();
					break;
			}
			wynik=0;
			break;
		case WM_DESTROY:
			KillTimer(uchwytOkna,IDT_TIMER_ANIMACJI);
			break;
	}
	
	return wynik;
}
#pragma endregion

#pragma region Zrodla swiatla
//zrodla swiatla
void CMojeOknoGL::ZrodlaSwiatla()
{
	natezenie_swiatla_tla=0.5f;
	MlecznaZarowka(0.5f);
	ZoltaIZielonaMleczneZarowki();
	Reflektor(1.0f,0.0f);

	/*
	//mgla
	glEnable(GL_FOG);
	const float biel[4]={1.0,1.0,1.0,1.0};
	glFogfv(GL_FOG_COLOR,biel);
	glFogf(GL_FOG_START,0.0);
	glFogf(GL_FOG_END,100.0);
	glFogf(GL_FOG_MODE,GL_LINEAR);
	*/	
}


void CMojeOknoGL::MlecznaZarowka(float jasnosc)
{	
	const float kolor[4]={jasnosc,jasnosc,jasnosc,1.0f};
	const float pozycja[4]={5.0f,0.0f,5.0f,1.0f};	
	glLightfv(GL_LIGHT1,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor);
	glEnable(GL_LIGHT1);
}

void CMojeOknoGL::ZoltaIZielonaMleczneZarowki()
{
	//zolta mleczna zarowka
	const float kolor_zolta[4]={1.0f,1.0f,0.0f,1.0f};
	const float pozycja_zolta[4]={-2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT2,GL_POSITION,pozycja_zolta);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_zolta);
	//glEnable(GL_LIGHT2);

	//zielona mleczna zarowka
	const float kolor_zielony[4]={0.0f,1.0f,0.0f,1.0f};
	const float pozycja_zielony[4]={2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT3,GL_POSITION,pozycja_zielony);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor_zielony);
	//glEnable(GL_LIGHT3);
}

void CMojeOknoGL::Reflektor(float jasnoscRozblysk,float jasnoscRozproszone)
{
	const float kolor_rozproszone[4]={jasnoscRozproszone,jasnoscRozproszone,jasnoscRozproszone,1.0f};
	const float kolor_rozblysk[4]={jasnoscRozblysk,jasnoscRozblysk,jasnoscRozblysk,1.0};
	const float pozycja[4]={-10.0f,-10.0f,10.0f,1.0f};	
	const float kierunek[4]={1.0,1.0,-1.0,1.0};   
	const float szerokosc_wiazki=30.0f; //w stopniach
	const float wygaszanie=1.0f;
   
	glLightfv(GL_LIGHT4,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT4,GL_DIFFUSE,kolor_rozproszone);

	glLightfv(GL_LIGHT4,GL_SPECULAR,kolor_rozblysk);
	glLightfv(GL_LIGHT4,GL_SPOT_DIRECTION,kierunek);
	glLightf(GL_LIGHT4,GL_SPOT_CUTOFF,szerokosc_wiazki);
	glLightf(GL_LIGHT4,GL_SPOT_EXPONENT,wygaszanie);
	//glEnable(GL_LIGHT4);
}
#pragma endregion


#pragma region Teksturowanie
//aktywna moze byc tylko jedna z ponizszych definicji
#define TeksturaDlaSfery //Ziemia
//#define TeksturaDlaNiszczycielaGwiazd
//#define TekstuaCzytanaZPliku //Nefryt
//#define TeksturyGenerowaneZeWzoru

#ifdef TeksturaDlaSfery
void CMojeOknoGL::PrzygotujTekstury()
{
	const int ILOSC_TEKSTUR=1;
	glGenTextures(ILOSC_TEKSTUR,indeksTekstury); //generowanie identyfikatora do tekstur (uchwytow, name to mylna nazwa)

	char* nazwyTekstur[ILOSC_TEKSTUR]={"ziemia.bmp"};

	int teksturaSzer;
	int teksturaWys;
	for(int it=0;it<ILOSC_TEKSTUR;it++)
	{
		//wczytanie tekstury
		unsigned long* tekstura=WczytajTeksture(uchwytOkna,nazwyTekstur[it],teksturaSzer,teksturaWys,false,255);

		glBindTexture(GL_TEXTURE_2D,indeksTekstury[it]); //kolejne polecenia beda dotyczyc tej tekstury
	
		//tworzenie tekstury z tablicy bitow
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		//glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);

		gluBuild2DMipmaps(GL_TEXTURE_2D,3,teksturaSzer,teksturaWys,GL_RGBA,GL_UNSIGNED_BYTE,tekstura);			
		//glTexImage2D(GL_TEXTURE_2D,0,GL_RGB,teksturaSzer,teksturaWys, 0, GL_RGBA, GL_UNSIGNED_BYTE, tekstura);
	
		delete[] tekstura; //oryginalne dane sa usuwane	
	}
}
#endif
#ifdef TeksturaDlaNiszczycielaGwiazd
void CMojeOknoGL::PrzygotujTekstury()
{
	const int ILOSC_TEKSTUR=2;
	glGenTextures(ILOSC_TEKSTUR,indeksTekstury); //generowanie identyfikatora do tekstur (uchwytow, name to mylna nazwa)

	char* nazwyTekstur[ILOSC_TEKSTUR]={"TeksturaNadbudowki.bmp","TeksturaKadluba.bmp"};

	int teksturaSzer;
	int teksturaWys;
	for(int it=0;it<ILOSC_TEKSTUR;it++)
	{
		//wczytanie tekstury
		unsigned long* tekstura=WczytajTeksture(uchwytOkna,nazwyTekstur[it],teksturaSzer,teksturaWys,false,255);
		//unsigned long* tekstura=WczytajTeksture(uchwytOkna,MAKEINTRESOURCE(IDB_DEATHSTAR),teksturaSzer,teksturaWys,true,255);

		glBindTexture(GL_TEXTURE_2D,indeksTekstury[it]); //kolejne polecenia beda dotyczyc tej tekstury
	
		//tworzenie tekstury z tablicy bitow
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);

		gluBuild2DMipmaps(GL_TEXTURE_2D,4,teksturaSzer,teksturaWys,GL_RGBA,GL_UNSIGNED_BYTE,tekstura);	
	
		delete[] tekstura; //oryginalne dane sa usuwane	
	}
}
#endif

#ifdef TekstuaCzytanaZPliku
void CMojeOknoGL::PrzygotujTekstury()
{
	glGenTextures(1,indeksTekstury); //generowanie identyfikatora do tekstur (uchwytow, name to mylna nazwa)

	int teksturaSzer;
	int teksturaWys;
	//wczytanie tekstury
	//unsigned long* tekstura=WczytajTeksture(uchwytOkna,"Nefryt.bmp",teksturaSzer,teksturaWys,false,255);	
	unsigned long* tekstura=WczytajTeksture(uchwytOkna,MAKEINTRESOURCE(IDB_NEFRYT),teksturaSzer,teksturaWys,true,255);
	//unsigned long* tekstura=WczytajTeksture(uchwytOkna,"tekstura_24bit.bmp",teksturaSzer,teksturaWys,128);
	//unsigned long* tekstura=WczytajTeksture(uchwytOkna,"tekstura_1bit.bmp",teksturaSzer,teksturaWys,128);
	//unsigned long* tekstura=WczytajTeksture(uchwytOkna,"tekstura_8bit.bmp",teksturaSzer,teksturaWys,128);
	//unsigned long* tekstura=WczytajTeksture(uchwytOkna,"tekstura_4bit.bmp",teksturaSzer,teksturaWys,128);

	glBindTexture(GL_TEXTURE_2D,indeksTekstury[0]); //kolejne polecenia beda dotyczyc tej tekstury
	
	//tworzenie tekstury z tablicy bitow
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);

	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
	//glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);

	glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);

	gluBuild2DMipmaps(GL_TEXTURE_2D,4,teksturaSzer,teksturaWys,GL_RGBA,GL_UNSIGNED_BYTE,tekstura);
	
	delete[] tekstura; //oryginalne dane sa usuwane	
}
#endif

#ifdef TeksturyGenerowaneZeWzoru
//Trzy tekstury dla szescianu
void CMojeOknoGL::PrzygotujTekstury()
{
	const int ILOSC_TEKSTUR=3;
	glGenTextures(ILOSC_TEKSTUR,indeksTekstury); //generowanie identyfikatora do tekstur (uchwytow, name to mylna nazwa)

	int teksturaSzer=4;
	int teksturaWys=4;

	unsigned long* tekstura[ILOSC_TEKSTUR];
	for(int it=0;it<ILOSC_TEKSTUR;it++)
	{
		//przygotowanie trzech tablicy pikseli
		tekstura[it]=new unsigned long[teksturaSzer*teksturaWys]; //32-bity na piksel
		for(int ih=0;ih<teksturaWys;ih++)
			for(int iw=0;iw<teksturaSzer;iw++)
			{
				bool ciemniejsza=((iw+ih)%2)?true:false;
				unsigned char R=0,G=0,B=0,A=128;
				switch(it)
				{
					case 0:
						R=0; 
						G=(ciemniejsza)?0:255;
						B=255;
						break;
					case 1:
						R=255; 
						G=0;
						B=(ciemniejsza)?0:255;;
						break;
					case 2:
						R=(ciemniejsza)?0:255; 
						G=255;
						B=0;
						break;
				}
				tekstura[it][iw+(ih*teksturaSzer)]=(A << 24) + (B << 16) + (G << 8) + (R);
			}	
	}
	
	for(int it=0;it<ILOSC_TEKSTUR;it++)
	{
		glBindTexture(GL_TEXTURE_2D,indeksTekstury[it]); //kolejne polecenia beda dotyczyc tej tekstury

		//tworzenie tekstury z tablicy bitow
		//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		//float kolorPodkladu[4]={0.0f,1.0f,0.0f,1.0f};
		//glTexEnvfv(GL_TEXTURE_ENV,GL_TEXTURE_ENV_COLOR,kolorPodkladu);
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);

		glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,teksturaSzer,teksturaWys, 0, GL_RGBA, GL_UNSIGNED_BYTE, tekstura[it]);
		//gluBuild2DMipmaps(GL_TEXTURE_2D,4,teksturaSzer,teksturaWys,GL_RGBA, GL_UNSIGNED_BYTE, tekstura[it]);

		delete[] tekstura[it]; //oryginalne dane sa usuwane
	}
}
#endif
#pragma endregion

